define([
    'backbone',
    'underscore',
    'modules/new-appointment-request/resources/common/facility/collection',
    'modules/new-appointment-request/tests/helpers/facility-helper',
], function(Backbone, _, Collection, helpers) {
    'use strict';

    describe('Patient Facilities Collection', function() {

        var data;

        beforeEach(function() {
            data = helpers.mockPatientFacility();
            helpers.userSpy();

            spyOn(Backbone.Collection.prototype, 'sync');
        });

        it('builds the url correctly', function() {
            var expectedUrl = 'base-url/VeteranAppointmentRequestService/v4/rest/direct-scheduling/institutions';

            var _collection = new Collection();
            var url = _.result(_collection, 'url');

            expect(url).toEqual(expectedUrl);
        });

        it('uses the facility code key to map enrolled facilities', function() {
            var FACILITY_CODE = '101';
            var _collection = new Collection();
            var model = new Backbone.Model({facilityCode: FACILITY_CODE});
            var output = _collection._mapCodes(model);

            expect(output).toBe(FACILITY_CODE);
        });

        it('creates section view data correctly', function() {
            var _collection = new Collection(data, {parse: true});
            var itemBuilder = function(id, text) {
                return {
                    id: id,
                    value: id,
                    text: text,
                    hasPactLabel: false,
                };
            };
            var expected = [];

            // Note: the collection sorts these by name
            expected.push(itemBuilder('631GD', 'GREENFIELD (CBOC) (GREENFIELD, MA)'));
            expected.push(itemBuilder('631GC', 'PITTSFIELD CBOC (PITTSFIELD, MA)'));
            expected.push(itemBuilder('631GE', 'WORCESTER CBOC (WORCESTER, MA)'));

            expect(_collection.toSectionData()).toEqual(expected);
        });

        it('sorts the collection by name', function() {
            var LESS_THAN = -1;

            var _collection = new Collection(data, {parse: true});
            var first = _collection.at(0).get('name');
            var second = _collection.at(1).get('name');
            var third = _collection.at(2).get('name');

            expect(first.localeCompare(second)).toBe(LESS_THAN);
            expect(second.localeCompare(third)).toBe(LESS_THAN);
        });
    });
});
